<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attachment extends Model 
{

    protected $table = 'attachments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('size', 'mime', 'path');
    protected $visible = array('size', 'mime', 'path');

    public function images()
    {
        return $this->hasMany('Image', 'attachment_id');
    }

}